/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.brewing.feature;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.Charm;
import svenhjol.charm.brewing.block.BlockFlavoredCake;
import svenhjol.charm.brewing.message.MessageCakeImbue;
import svenhjol.charm.crafting.feature.Composter;
import svenhjol.meson.Feature;
import svenhjol.meson.Meson;
import svenhjol.meson.handler.NetworkHandler;
import svenhjol.meson.helper.ForgeHelper;
import svenhjol.meson.helper.ItemHelper;
import svenhjol.meson.helper.SoundHelper;

public class FlavoredCake
extends Feature {
    public static Map<String, BlockFlavoredCake> cakes = new HashMap<String, BlockFlavoredCake>();
    public static Map<PotionType, BlockFlavoredCake> cakeTypes = new HashMap<PotionType, BlockFlavoredCake>();
    public static String[] validPotions;
    public static double multiplier;

    @Override
    public String getDescription() {
        return "Right-click a Long Potion on a cake make a Flavored Cake that gives a potion effect after eating each slice.";
    }

    @Override
    public void configure() {
        super.configure();
        multiplier = this.propDouble("Effect duration multiplier", "Duration multiplier of the potion effect when eating a single slice of cake.", 0.5);
        validPotions = this.propStringList("Effect potion types", "List of Long Potions that can be used to make a cake.", new String[]{"swiftness", "strength", "leaping", "regeneration", "fire_resistance", "water_breathing", "invisibility", "night_vision", "quark:danger_sight", "quark:haste", "quark:resistance", "quark:resilience"});
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        for (String name : validPotions) {
            String modName = "";
            String baseName = name;
            if (name.contains(":")) {
                String[] split = name.split(":");
                modName = split[0];
                baseName = split[1];
            }
            if (!modName.isEmpty() && !ForgeHelper.areModsLoaded(modName)) continue;
            BlockFlavoredCake cake = new BlockFlavoredCake(baseName);
            cakes.put(name, cake);
            if (!Charm.hasFeature(Composter.class)) continue;
            Composter.inputs.put(Objects.requireNonNull(cake.getRegistryName()).toString(), Float.valueOf(1.0f));
        }
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151068_bn, (Object)new DispenseHandlerImbue());
        NetworkHandler.register(MessageCakeImbue.class, Side.CLIENT);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        for (String name : cakes.keySet()) {
            String n;
            String[] names;
            String strongName;
            String longName;
            String[] modName;
            PotionType type = null;
            BlockFlavoredCake cake = cakes.get(name);
            int duration = 0;
            if (name.contains(":")) {
                String[] split = name.split(":");
                modName = split[0];
                longName = (String)modName + ":long_" + split[1];
                strongName = (String)modName + ":strong_" + split[1];
            } else {
                longName = "long_" + name;
                strongName = "strong_" + name;
            }
            modName = names = new String[]{longName, strongName, name};
            int n2 = modName.length;
            for (int i = 0; i < n2 && ((type = PotionType.func_185168_a((String)(n = modName[i]))) == null || type.func_185170_a().isEmpty()); ++i) {
            }
            if (type == null || type.func_185170_a().isEmpty()) {
                Meson.log("Cannot find PotionType for " + name + ", skipping");
                continue;
            }
            ItemStack potionItem = ItemHelper.getPotionBottle(1, type);
            List effects = PotionUtils.func_185189_a((ItemStack)potionItem);
            for (PotionEffect effect : effects) {
                duration = Math.max(duration, effect.func_76459_b());
            }
            if (duration == 0) {
                duration = 10;
            }
            cake.setPotionItem(potionItem, duration);
            cakeTypes.put(type, cake);
        }
    }

    @SubscribeEvent
    public void onUse(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getEntityPlayer().func_184586_b(event.getHand());
        boolean result = this.imbue(event.getWorld(), event.getPos(), held);
        if (result) {
            event.setCanceled(true);
        }
    }

    private boolean imbue(World world, BlockPos pos, ItemStack item) {
        PotionType potionItem;
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150414_aQ && cakeTypes.containsKey(potionItem = PotionUtils.func_185191_c((ItemStack)item))) {
            IBlockState current = world.func_180495_p(pos);
            IBlockState imbued = cakeTypes.get(potionItem).func_176223_P().func_177226_a((IProperty)BlockFlavoredCake.field_176589_a, current.func_177229_b((IProperty)BlockFlavoredCake.field_176589_a));
            world.func_180501_a(pos, imbued, 2);
            item.func_190918_g(1);
            if (!world.field_72995_K) {
                NetworkHandler.INSTANCE.sendToAll((IMessage)new MessageCakeImbue(pos));
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void cakeImbued(BlockPos pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        SoundHelper.playSoundAtPos((World)world, pos, SoundEvents.field_191241_J, 0.5f, 1.1f);
        for (int i = 0; i < 8; ++i) {
            double d0 = world.field_73012_v.nextGaussian() * 0.02;
            double d1 = world.field_73012_v.nextGaussian() * 0.02;
            double d2 = world.field_73012_v.nextGaussian() * 0.02;
            double dx = (float)pos.func_177958_n() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
            double dy = (float)pos.func_177956_o() + 0.65f;
            double dz = (float)pos.func_177952_p() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
            world.func_175688_a(EnumParticleTypes.SPELL_WITCH, dx, dy, dz, d0, d1, d2, new int[0]);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public class DispenseHandlerImbue
    extends BehaviorDefaultDispenseItem {
        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            BlockPos pos;
            World world = source.func_82618_k();
            boolean result = FlavoredCake.this.imbue(world, pos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)), stack);
            if (!result) {
                return super.func_82487_b(source, stack);
            }
            return stack;
        }
    }
}

